<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Consultas extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('registro_academico_model');
        $this->load->model('personal_model');
        $this->load->model('gsatelite');

        $this->load->library('pdf');
        $this->load->library('excel/excel_reader.php');
    }

    function index()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {            
            $this->_cargarvista();
        }
    }



 function notas_modulo()
        {
            if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
            } else {
                //$data['proveedor']=$this->inventario_model->proveedor_con_mov();

                    $areasAcademicas = $this->gsatelite->get_tabla('ard_area_academica');

                 $data["areas_academicas"] = $areasAcademicas;    

                $data["titulo_personal"] ="Reporte de notas por modulo";

                //$data['detalle']=$this->inventario_model->consultaxproveedor();
                $this->_cargarvista($data);
                //$this->load->view('registro_academico/consultas/notas_modulo',$data);
            }
        }


public function consultar_notas_modulos()
{
   
            $modulo= $this->input->post('modulo');

            //$rpt=$this->input->post('rpt');
            $datos_notas_mod=$this->personal_model->obtener_notas_modulos($modulo);
           
            //die(print_r($datos_notas_mod,true));

            $cadena="";


              

            foreach ($datos_notas_mod as $key => $sld) {
                //$numero=explode(',', $sld['precios_costos']);
                //$dos="";
              
               
                $cadena.="<tr><td>".$sld['alm_codigo']."</td>";
                $cadena.="<td>".$sld['alm_nombre']." ".$sld['alm_apellido']."</td>";
                $cadena.="<td>".$sld['noa_nota']."</td></tr>";
                
            }

            //die(print_r($cadena,true));
              if (!empty($datos_notas_mod)) {

            $arreglo=array('drop'=>$cadena);
            echo json_encode($arreglo);

        }else {
            $arreglo=array('drop'=>"No existen notas");
            echo json_encode($arreglo);
        }
}



public function mostrar_modulos($value='')
{
    if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
            } else {
                
                      $area= $_POST['idP'];

                    $modulos_extraidos = $this->personal_model->obtener_modulos($area);

                    //die(print_r($modulos_extraidos,true));



                    if (!empty($modulos_extraidos)) {

                    $cadena="";

                foreach ($modulos_extraidos as $key => $value) {
                    $cadena.="<option value='".$value['mod_id']."'>".$value['mod_nombre']."</option>";
                }

                        echo json_encode(array('modulosjson' => $cadena));

                } else {
                            

                    echo json_encode(array('modulosjson' => "<option>no existen modulos para esta área</option>" ));

                }

                   
            }
}
    

public function reporte_notas_modulos($id)
{
    //$id= $this->input->get('id');

           // $rpt=$this->input->post('rpt');
            
            $datos_notas_mod=$this->personal_model->obtener_notas_modulos($id);
           
            //die(print_r($datos_notas_mod,true));
            foreach ($datos_notas_mod as $key => $modulo) {

                $modulo=$modulo['mod_nombre'];
            }


            $cadena="";

            //$rows="REPORTES DE NOTAS POR ALUMNO";

                $rows=$this->load->view('reporte/header', array('titulo' => "Notas Modulo ".$modulo.""), true);
              $cadena='<meta http-equiv="content-type" content="text/html; charset=utf-8"><table class="tabla" style="border:1px solid black;">';
                $cadena.='<tr style="background-color: #C0C0C0;">';
                $cadena.='<th style="text-align:center; font-weight:bold;">Codigo</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;">Alumno</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;">Nota</th>';
                $cadena.='</tr>';

            foreach ($datos_notas_mod as $key => $sld) {
                //$numero=explode(',', $sld['precios_costos']);
                //$dos="";
              

                $cadena.="<tr><td>".$sld['alm_codigo']."</td>";
                $cadena.="<td>".$sld['alm_nombre']." ".$sld['alm_apellido']."</td>";
                $cadena.="<td>".$sld['noa_nota']."</td></tr>";
                
            }

            $cadena.='</table>';

            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

            $data['table_header']     = $rows;
            $data['table_tbody']      = $cadena;
            $data['filename']         = $filename;

            
                 $this->pdf->reportePDF('inventario/reportes/reporte_existencia_pdf.php', $data);
                // $this->load->view('registro_academico/consultas/consultar_notas_modulos');
         

           
}


function notas_alumno()
        {
            if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
            } else {
                //$data['proveedor']=$this->inventario_model->proveedor_con_mov();

                    $areasAcademicas = $this->gsatelite->get_tabla('ard_area_academica');

                 $data["areas_academicas"] = $areasAcademicas;    

                $data["titulo_personal"] ="Reporte de notas por Alumno";

                //$data['detalle']=$this->inventario_model->consultaxproveedor();
                $this->_cargarvista($data);
                //$this->load->view('registro_academico/consultas/notas_modulo',$data);
            }
        }


public function mostrar_alumnos($value='')
{
    if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
            } else {
                
                      $area= $_POST['idP'];

                    $alumnos_extraidos = $this->personal_model->obtener_alumnos($area);

                    //die(print_r($modulos_extraidos,true));



                    if (!empty($alumnos_extraidos)) {

                    $cadena="";

                foreach ($alumnos_extraidos as $key => $value) {
                    $cadena.="<option value='".$value['alm_id']."'>".$value['alm_nombre']."</option>";
                }

                        echo json_encode(array('alumjson' => $cadena));

                } else {
                            

                    echo json_encode(array('alumjson' => "<option>no existen alumnos para esta área</option>" ));

                }

                   
            }
}

public function consultar_notas_alumnos()
{
   
            $alm= $this->input->post('alm');

            //$rpt=$this->input->post('rpt');
            $datos_notas_alm=$this->personal_model->obtener_notas_alm($alm);
           
            //die(print_r($datos_notas_alm,true));

            $cadena="";


              

            foreach ($datos_notas_alm as $key => $sld) {
                //$numero=explode(',', $sld['precios_costos']);
                //$dos="";
              
               
                $cadena.="<tr><td>".$sld['mod_id']."</td>";
                $cadena.="<td>".$sld['mod_nombre']."</td>";
                $cadena.="<td>".$sld['noa_nota']."</td></tr>";
                
            }

            //die(print_r($cadena,true));
              if (!empty($datos_notas_alm)) {

            $arreglo=array('drop'=>$cadena);
            echo json_encode($arreglo);

        }else {
            $arreglo=array('drop'=>"No existen notas");
            echo json_encode($arreglo);
        }
}


public function reporte_notas_alumno($id)
{
    //$id= $this->input->get('id');

           // $rpt=$this->input->post('rpt');
            
            $datos_notas_alm=$this->personal_model->obtener_notas_alm($id);
           
            //die(print_r($datos_notas_mod,true));
            foreach ($datos_notas_alm as $key => $alum) {

                $alumno=$alum['alm_nombre']." ".$alum['alm_apellido'];
            }


            $cadena="";

            //$rows="REPORTES DE NOTAS POR ALUMNO";

                $rows=$this->load->view('reporte/header', array('titulo' => "Notas de Alumno ".$alumno.""), true);
              $cadena='<meta http-equiv="content-type" content="text/html; charset=utf-8"><table class="tabla" style="border:1px solid black;">';
                $cadena.='<tr style="background-color: #C0C0C0;">';
                $cadena.='<th style="text-align:center; font-weight:bold;">Codigo</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;">Modulo</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;">Nota</th>';
                $cadena.='</tr>';

            foreach ($datos_notas_alm as $key => $sld) {
                //$numero=explode(',', $sld['precios_costos']);
                //$dos="";
              

                 $cadena.="<tr><td>".$sld['mod_id']."</td>";
                $cadena.="<td>".$sld['mod_nombre']."</td>";
                $cadena.="<td>".$sld['noa_nota']."</td></tr>";
                
            }

            $cadena.='</table>';

            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

            $data['table_header']     = $rows;
            $data['table_tbody']      = $cadena;
            $data['filename']         = $filename;

            
                 $this->pdf->reportePDF('inventario/reportes/reporte_existencia_pdf.php', $data);
                // $this->load->view('registro_academico/consultas/consultar_notas_modulos');
         

           
}
  
    //CALLBACKS

    function _fecha_inscripcion($value,$row){
        $date = new DateTime($value);

        return '<div>'.$date->format('d/m/Y').'</div>';
    }
    
    function _cargarvista($data=0,$crud=0){   
        $this->load->view('vacia',$crud);   
        if($data!=0)
            $data=array_merge($data,$this->masterpage->getUsuario());
        else
            $data=$this->masterpage->getUsuario();      
        $vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content',$data);
        $this->masterpage->show();
    }
} // End of class